#include <windows.h>
#include <stdio.h>
#include <zlib.h>

typedef struct
{
	DWORD signature;
	DWORD decompSize;
	DWORD reserved[6];
} DAXHEADER;

#define DAX_SIGNATURE 0x00584144

BYTE combuf[9216], decbuf[8192];
DWORD *offsets; 
WORD *lengths;

char szIsoFileName[MAX_PATH] = "";
char szDaxFileName[MAX_PATH] = "";

void gotoxy(int xpos, int ypos)
{
	COORD scrn;   

	HANDLE hOutput = GetStdHandle(STD_OUTPUT_HANDLE);

	scrn.X = xpos; 
	scrn.Y = ypos;

	SetConsoleCursorPosition(hOutput,scrn);
}

int getx()
{
	CONSOLE_SCREEN_BUFFER_INFO csbi;

	HANDLE hOutput = GetStdHandle(STD_OUTPUT_HANDLE);

	GetConsoleScreenBufferInfo(hOutput, &csbi);

	return csbi.dwCursorPosition.X;	
}

int gety()
{
	CONSOLE_SCREEN_BUFFER_INFO csbi;

	HANDLE hOutput = GetStdHandle(STD_OUTPUT_HANDLE);

	GetConsoleScreenBufferInfo(hOutput, &csbi);

	return csbi.dwCursorPosition.Y;	
}

int main()
{
	OPENFILENAME ofn;
	DAXHEADER header;
	HANDLE hIsoFile, hDaxFile;
	DWORD nFrames, read, written, csize, fpointer;	
	int i, error;
	int x, y;
	int compressionlevel;

	printf("DAX Creator 0.2 (by Dark_AleX)\n\n");

    ZeroMemory(&ofn, sizeof(ofn));

    ofn.lStructSize = sizeof(ofn); 
    ofn.hwndOwner = GetActiveWindow();
    ofn.lpstrFilter = "DAX Files (*.dax)\0*.dax\0All Files (*.*)\0*.*\0\0";
    ofn.lpstrFile = szIsoFileName;
    ofn.nMaxFile = MAX_PATH;
    ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
    ofn.lpstrDefExt = "iso";

    if(!GetOpenFileName(&ofn))
    {
        return -1; 
    }

	lstrcpy(szDaxFileName, szIsoFileName);
	lstrcat(szDaxFileName, ".dax");
	
	ZeroMemory(&ofn, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn); 
    ofn.hwndOwner = GetActiveWindow();
    ofn.lpstrFilter = "DAX Files (*.dax)\0*.dax\0All Files (*.*)\0*.*\0\0";
    ofn.lpstrFile = szDaxFileName;
    ofn.nMaxFile = MAX_PATH;
    ofn.Flags = OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
    ofn.lpstrDefExt = "dax";

    if(!GetSaveFileName(&ofn))
    {
        return -1; 
    }

	hIsoFile = CreateFile(szIsoFileName, GENERIC_READ, FILE_SHARE_READ, NULL,
        OPEN_EXISTING, 0, NULL);

	if (hIsoFile == INVALID_HANDLE_VALUE)
	{
		printf("Cannot open input file %s\n", szIsoFileName);
		return -1;
	}	

	hDaxFile = CreateFile(szDaxFileName, GENERIC_WRITE, 0, NULL,
        CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);

	if (hDaxFile == INVALID_HANDLE_VALUE)
	{
		printf("Cannot create output file %s\n", szDaxFileName);
		return -1;
	}

	do
	{
		printf("Enter compression level(0-9):\n"
			   "0 -> use default compromise between speed and compression\n"
			   "1 -> faster but worse compression\n"
			   "9 -> slower but better compression\n");
		scanf("%d", &compressionlevel);

	} while (compressionlevel < 0 || compressionlevel >= 10);

	if (compressionlevel == 0)
		compressionlevel = Z_DEFAULT_COMPRESSION;

	ZeroMemory(&header, sizeof(header));
	header.signature = DAX_SIGNATURE;
	header.decompSize = GetFileSize(hIsoFile, NULL);

	if (header.decompSize == INVALID_FILE_SIZE)
	{
		printf("Error getting file size.\n");
		CloseHandle(hIsoFile);
		CloseHandle(hDaxFile);
		return -1;
	}

	nFrames = header.decompSize / 8192;

	if ((header.decompSize % 8192) != 0)
		nFrames++;

	printf("N of frames: %d\n", nFrames);

	offsets = (DWORD *)GlobalAlloc(GPTR, nFrames * 4);
	lengths = (WORD *) GlobalAlloc(GPTR, nFrames * 2);

	WriteFile(hDaxFile, &header, sizeof(header), &written, NULL);
	WriteFile(hDaxFile, offsets, nFrames * 4, &written, NULL);
	WriteFile(hDaxFile, lengths, nFrames * 2, &written, NULL);

	printf("Compressing...  ");
	
	x = getx();
	y = gety();

	fpointer = sizeof(header) + (nFrames * 6);
	error = 0;
	i = 0;

	do
	{
		int res;

		ReadFile(hIsoFile, decbuf, 8192, &read, NULL);

		if (read > 0)
		{
			csize = 9216;
			res = compress2(combuf, &csize, decbuf, read, compressionlevel);
			
			if (res == Z_BUF_ERROR)
			{
				printf("Not enough memory in compressed buffer!\n");
				error = 1;
				break;
			}

			else if (res != Z_OK)
			{
				printf("Memory error while compressing.");
				error = 1;
				break;
			}

			WriteFile(hDaxFile, combuf, csize, &written, NULL);

			if (written != csize)
			{
				printf("I/O write error.\n");
				error = 1;
				break;
			}

			offsets[i] = fpointer;
			lengths[i] = (WORD)csize;
			i++;
			fpointer += csize;

			if ((i % 600) == 0)
			{
				if (((i * 100) / nFrames) != 100)
					gotoxy(x, y);
				else
					gotoxy(x-1, y);
				
				printf("%d%%", (i * 100) / nFrames);
			}

		}		
	} while (read == 8192);

	CloseHandle(hIsoFile);

	if (error)
	{
		CloseHandle(hDaxFile);
		return -1;
	}
	
	gotoxy(x-1, y);
	printf("100%%\n");

	printf("Total frames written: %d\n", i);
	
	printf("Writing tables...\n");
	if (SetFilePointer(hDaxFile, sizeof(header), NULL, FILE_BEGIN)
		!= sizeof(header))
	{
		printf("I/O error setting file pointer.\n");
		CloseHandle(hDaxFile);
		return -1;
	}

	WriteFile(hDaxFile, offsets, nFrames * 4, &written, NULL);
	WriteFile(hDaxFile, lengths, nFrames * 2, &written, NULL);

	printf("Table size: %d+%d=%d\n", nFrames*4, nFrames*2, nFrames*6);

	if (nFrames * 6 > 1048576)
	{
		printf("Warning: table greater than 1MB. It won't work.");
	}

	CloseHandle(hDaxFile);
	printf("Finished.\n\n");

	printf("Press any key to continue.");
	getchar();

	return 0;
}